/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonPrimitive;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class EnumConfigMapper
implements ValueMapper<Enum<?>, JsonPrimitive> {
    public static final ResourceLocation ID = new ResourceLocation("minecraft", "enum");
    private static final Map<Class<? extends Enum<?>>, EnumConfigMapper> mappers = new HashMap();
    private final Class<? extends Enum<?>> clazz;

    public static EnumConfigMapper getMapper(Class<? extends Enum<?>> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Can't get enum serializer for non-enum class: " + enumClass);
        }
        if (mappers.containsKey(enumClass)) {
            return mappers.get(enumClass);
        }
        EnumConfigMapper mapper = new EnumConfigMapper(enumClass);
        mappers.put(enumClass, mapper);
        return mapper;
    }

    public EnumConfigMapper(Class<? extends Enum<?>> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<Enum<?>> type() {
        return Enum.class;
    }

    @Override
    public Class<JsonPrimitive> element() {
        return JsonPrimitive.class;
    }

    @Override
    public Enum<?> fromJSON(JsonPrimitive json, Class<?> elementType) {
        Enum<?>[] enums;
        String str = json.getAsString();
        for (Enum<?> e : enums = this.clazz.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(str)) continue;
            return e;
        }
        throw new NoSuchElementException("Enum constant not found: " + str);
    }

    @Override
    public JsonPrimitive toJSON(Enum<?> value, Class<?> elementType) {
        return new JsonPrimitive(value.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public Enum<?> read(PacketBuffer buffer, Class<?> elementType) {
        return this.clazz.getEnumConstants()[buffer.func_150792_a()];
    }

    @Override
    public void write(Enum<?> value, PacketBuffer buffer, Class<?> elementType) {
        buffer.func_150787_b(value.ordinal());
    }

    @Override
    public List<String> comment(Class<?> elementType) {
        return ImmutableList.of((Object)("Allowed values: " + Arrays.stream(this.clazz.getEnumConstants()).map(e -> e.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", "))));
    }
}

